using System;
using System.Collections;
using UnityEngine;


public class ProductRotatory : MonoBehaviour, IProduct
{
    private string name = "RotatoryShield"; 
   
    private GameObject go;
    private AudioSource audio;
    [SerializeField]private GameObject particlePrefabs;
    [SerializeField] private GameObject pickUpParticle;
    private PlayerPower playerPower; 
    private Player2Power player2Power;
   
    
    

    public string Name { get => name; set => name = value; }
   

    public GameObject Go => go;

    

    private void Start()
    {
        audio = GetComponent<AudioSource>();
        go = GetComponent<GameObject>();
        playerPower = FindAnyObjectByType<PlayerPower>();
        player2Power = FindAnyObjectByType<Player2Power>();
        Behavior(); 
        Initialize();

    }
    public void Behavior()
    {
        InvokeRepeating("Animation", 0.1f, 3f); 
        
       
    }

    private void OnCollisionEnter2D(Collision2D collision)
    {
        PlayerPickUp(collision);
    }
    public void PlayerPickUp(Collision2D col)
    {
        if (col.gameObject.CompareTag("Player"))
        {
            if (!playerPower.PowerOn)
            {
                Destroy(gameObject);
                GameObject created = Instantiate(pickUpParticle, gameObject.transform.position, Quaternion.identity);
                Destroy(created, .5f);
                
            }
            
        }
        
        else if (col.gameObject.CompareTag("Player2"))
        {
            if (!player2Power.PowerOn)
            {
                Destroy(gameObject);
                GameObject created = Instantiate(pickUpParticle, gameObject.transform.position, Quaternion.identity);
                Destroy(created, .5f);
               
            }
            
        }
        
    }

    public void Initialize()
    {
        audio.Play();  
        GameObject particleCreated = Instantiate(particlePrefabs, transform.position, Quaternion.identity);

        particleCreated.transform.SetParent(transform, true);
    }

    private void Animation()
    {
        iTween.PunchScale(gameObject, new Vector3(.5f, .5f, .5f), 1f);
    }
}
