using UnityEngine;

public class FactoryRotatory :  IFactory
{
    [SerializeField] private ProductRotatory prefab; 

    public override IProduct GetProduct(Vector2 position)
    {
        GameObject created = Instantiate(prefab.gameObject, position, Quaternion.identity);
        ProductRotatory createdProduct = created.GetComponent<ProductRotatory>();
        return createdProduct;
    }
}
