﻿using System;
using UnityEngine;

public class AlienItemProduct : MonoBehaviour, IProduct
{
    private string name = "AlienItem"; 
    public string Name { get => name; set => name = value; }
    [SerializeField] private GameObject particlePrefab; 

    private void Start()
    {
        go = gameObject;
        Initialize();
        
    }

    public void Initialize()
    {
        //green particle : 
        GameObject createdParticle = Instantiate(particlePrefab, transform.position, Quaternion.identity);
        Destroy(createdParticle, 2f);
        
        //Sound : 
        SFXHandler.Instance.AlienItemSpawnSFX();
    }

    public void Behavior()
    {
        throw new System.NotImplementedException();
    }

    private GameObject go; 
    public GameObject Go { get => go; }

    private void OnCollisionEnter2D(Collision2D other)
    {
        HandleCollision(other);
    }

    private void HandleCollision(Collision2D col)
    {
        if ((col.gameObject.CompareTag("Player") || col.gameObject.CompareTag("Player2")))
        {
            Destroy(gameObject);
           
        }
              
            
    }
}