﻿using UnityEngine;
public class AlienItemFactory : IFactory
{
    [SerializeField] private AlienItemProduct prefab; 
    public override IProduct GetProduct(Vector2 position)
    {
        GameObject created = Instantiate(prefab.gameObject, position, Quaternion.identity);
        AlienItemProduct product = created.GetComponent<AlienItemProduct>();
        return product;
    }
}