using UnityEngine;


public class ShieldPowerProducts : MonoBehaviour, IProduct
{
    private string name = "ShieldPower";
    private GameObject go;
    private Transform player;
    private Transform player2;
    private Transform trans;
    private int life = 3;
    [SerializeField] private GameObject destroyedParticle; 

    string IProduct.Name { get => name; set => name = value ; }

    public GameObject Go => go;

    public int Life { get => life; set => life = value; }

    private void Start()
    {
        go = GetComponent<GameObject>();    
        trans = GetComponent<Transform>();  
        player = GameObject.Find("Player").GetComponent<Transform>();
        player2 = GameObject.Find("Player2").GetComponent<Transform>();
        Initialize();
    }

    public void Behavior()
    {
        
    }
    private void OnCollisionEnter2D(Collision2D collision)
    {
        HandleCollision(collision);
    }

    public void HandleCollision(Collision2D col)
    {
        if (col.gameObject.CompareTag("damage"))
        {
            life--; 
        }
        HandleLife(); 
    }
    public void HandleLife()
    {
        if (life == 0)
        {
            Destroy(gameObject);
            GameObject created = Instantiate(destroyedParticle, trans.position, Quaternion.identity);
            Destroy(created, .5f); 
        }
    }

    public void Initialize()
    {
        Parentage(); 
        Destroy(gameObject, 15); 
    }

    public void Parentage()
    {
        float dP1 = Vector2.Distance(trans.position, player.position);
        float dP2 = Vector2.Distance(trans.position, player2.position);
        if (dP1 < dP2)
            trans.SetParent(player);
        else if (dP1 > dP2)
            trans.SetParent(player2);



        //utiliser la distance de l'item par rapport au joeur pour choisir le bon.

    }

}
