using UnityEngine;

public class RotatoryFactory : IFactory
{

    [SerializeField] private RotatoryProducts prefab; 

    public override IProduct GetProduct(Vector2 position)
    {
        GameObject created = Instantiate(prefab.gameObject, position, Quaternion.identity);   
        RotatoryProducts createdProduct = created.GetComponent<RotatoryProducts>();
        return createdProduct;

    }
}
