﻿using System;
using System.Collections;
using UnityEngine;
using UnityEngine.AI;

public class AlienProduct : MonoBehaviour, IProduct
{
    private string name = "Alien"; 
    public string Name { get => name; set => name = value; }
    private Transform player1; 
    private Transform player2; 
    private Transform target; 
    private NavMeshAgent agent;
    private int life = 3;
    [SerializeField] private Material baseMat;
    [SerializeField] private Material damageMat;
    private bool immunityOff = true;
    private CircleCollider2D collider;
    private Animation mainCameraAnim; 
    

    private void Start()
    {
        mainCameraAnim = GameObject.Find("Main Camera").GetComponent<Animation>();
        player1 = GameObject.Find("Player").GetComponent<Transform>();
        player2 = GameObject.Find("Player2").GetComponent<Transform>();
        agent = GetComponent<NavMeshAgent>();
        collider = GetComponent<CircleCollider2D>();
        go = gameObject;
        StartCoroutine("StartCollider"); 
        Initialize();
    }

    private void Update()
    {
        Behavior();
    }

    public void Initialize()
    {
        agent.updateUpAxis = false;
        agent.updateRotation = false;   
        ChooseTarget();
        StartCoroutine("AnimCor");
    }

    public void Behavior()
    {
        agent.SetDestination(target.position);
        if (life == 0)
        {
            
            Destroy(gameObject);
        }
           
    }

    private GameObject go; 
    public GameObject Go { get => go; }
    
    private void ChooseTarget()
    {
        if (Vector2.Distance(player1.position, transform.position) <
            Vector2.Distance(player2.position, transform.position))
        {
            target = player2;
        }
        else
        {
            target = player1;
        }
    }

    private void OnTriggerEnter2D(Collider2D other)
    {
        if ((other.gameObject.CompareTag("damage") || other.gameObject.CompareTag("damageStay")) && immunityOff)
        {
            life--;
            StartCoroutine("DamageAnim"); 
            SFXHandler.Instance.AlienHurtSFX();
            StartCoroutine("ImmunityCor"); 
        }
    }

    IEnumerator DamageAnim()
    {
        gameObject.GetComponent<SpriteRenderer>().material = damageMat;
        yield return new WaitForSeconds(.5f); 
        gameObject.GetComponent<SpriteRenderer>().material = baseMat;
    }
    IEnumerator ImmunityCor()
    {
        immunityOff = false;
        yield return new WaitForSeconds(1f); 
        immunityOff = true;
    }

    IEnumerator StartCollider()
    {
        yield return new WaitForSeconds(2f); 
        collider.enabled = true;
    }

    public void Damage(int damage)
    {
        StartCoroutine("DamageAnim");
        StartCoroutine("ImmunityCor");
        life += damage; 
    }

    IEnumerator AnimCor()
    {
        while (true)
        {
            if (!mainCameraAnim.isPlaying)
                mainCameraAnim.Play("drunkCam");
            yield return new WaitForSeconds(3f);
        }
    }
}