﻿using UnityEngine;

public class AlienFactory : IFactory
{
    [SerializeField] private AlienProduct prefab; 
    public override IProduct GetProduct(Vector2 position)
    {
        
        GameObject created = Instantiate(prefab.gameObject, position, Quaternion.identity);
        AlienProduct product = created.GetComponent<AlienProduct>();
        return product;
    }
}