using System;
using DG.Tweening;
using UnityEngine;


public class CameraEffect : MonoBehaviour
{
    
    //singleton : 
    private static CameraEffect instance;

    public static CameraEffect Instance //instance public 
    {
        get
        {
            if (instance == null)
            {
                SetupInstance();
            }
            return instance;
                
        }
    }

    private void Awake() //on v�rifie qu'il n'y a qu'une seule et unique instance
    {
        if (instance == null)
        {
            instance = this;
        }
        else
        {
            Destroy(gameObject);
        }
    }

    private static void SetupInstance() //setup de l'instance
    {
        instance = FindFirstObjectByType<CameraEffect>();   
        if (instance == null)
        {
            GameObject obj = new GameObject();
            obj.name = "CameraEffect_singleton"; 
            instance = obj.AddComponent<CameraEffect>();
        }
    }
    
    //fin singleton

    private GameObject cam;
    private Animator anim; 
    private void Start()
    {
        cam = GameObject.Find("Main Camera");
    }

    public void Shake(Vector3 amount, float duration)
    {
        iTween.ShakePosition(cam, amount, duration); 
    }

    public void ShakeThis(GameObject obj, Vector3 amount, float duration)
    {
        print("test");
        iTween.ShakePosition(obj, amount, duration); 
    }

    
    
    
}
