using System.Collections;
using UnityEngine;
public class TornadoProduct : MonoBehaviour, IEventProduct
{
    private GameObject go;
    [SerializeField] Transform[] pathPoints;
    private int currentpathIndex = 0;
    private Transform trans;
    private Rigidbody2D rb;
    public GameObject Go => go;
    [SerializeField] private float speed = 5;
    [SerializeField] private float attractRadius = 1000;
    [SerializeField] private float attractForce = 1000;
    private Transform player;
    private Transform player2; 
    private EventGenerator eventGenerator; 
    



    private void Start()
    {
        go = gameObject;
        trans = GetComponent<Transform>();
        rb = GetComponent<Rigidbody2D>();
        pathPoints[0] = GameObject.Find("tornadopathR").transform;
        pathPoints[1] = GameObject.Find("tornadopathL").transform;
        player = GameObject.Find("Player").GetComponent<Transform>();
        player2 = GameObject.Find("Player2").GetComponent<Transform>();
        eventGenerator = GameObject.Find("EventGenerator").GetComponent<EventGenerator>();
    }

    private void Update()
    {
        Behaviour();
    }
    public void Behaviour()
    {
        HandleDirection();
        AttractPlayer();

    }

    public void Initialize()
    {
        StartCoroutine("DestroyCor");
        eventGenerator.EventGenerated = true; 
        HandleAnimation();
    }

    private void HandleDirection()
    {
        Vector2 dir = pathPoints[currentpathIndex].position - transform.position;
        if (Vector2.Distance(pathPoints[currentpathIndex].position, trans.position) < .5f)
        {            
            SFXHandler.Instance.TornadoSFX();
            rb.linearVelocity *= .5f;
            ChangeDirection();
        }
        rb.AddForce(dir * Time.deltaTime * speed);
    }
    private void ChangeDirection()
    {
        if (currentpathIndex == 0)
        {
            currentpathIndex = 1;
        }
        else
        {
            currentpathIndex = 0;
        }
    }

    IEnumerator DestroyCor()
    {
        yield return new WaitForSeconds(15f);
        eventGenerator.EventGenerated = false;
        Destroy(gameObject);
    }

    private void HandleAnimation()
    {
        Vector3 amount = new Vector3(15,15,15);
        float randomTime = Random.Range(Time.time - .1f, Time.time + .1f);

        iTween.PunchScale(gameObject, iTween.Hash(
            "amount", amount,
            "time", randomTime,
            "looptype", iTween.LoopType.loop
            ));
    }

    private void AttractPlayer()
    {
        
        Vector2 dir = new Vector2(trans.position.x - player.position.x, trans.position.y - player.position.y);
        Vector2 dir2 = new Vector2(trans.position.x - player2.position.x, trans.position.y - player2.position.y);
        

        if (Vector2.Distance(trans.position, player.position) < attractRadius)
        {
            player.GetComponent<Rigidbody2D>().AddForce(dir * Time.deltaTime * attractForce); 
        }
        
        if (Vector2.Distance(trans.position, player2.position) < attractRadius)
        {
            player2.GetComponent<Rigidbody2D>().AddForce(dir * Time.deltaTime * attractForce); 
        }

        
    }
        




   
}
