using UnityEngine;

public class TornadoFactory : EventFactory
{
    [SerializeField] private TornadoProduct prefab; 
    public override IEventProduct GetProduct(Vector2 position)
    {
        GameObject created = Instantiate(prefab.gameObject, position, Quaternion.identity);
        TornadoProduct product = created.GetComponent<TornadoProduct>();
        product.Initialize(); 
        return product; 
    }
}
