using System;
using UnityEngine;
using Random = UnityEngine.Random;

public class EventGenerator : MonoBehaviour
{
    private TornadoFactory tornadoFactory;
    private BlackHoleFactory blackHoleFactory; 
    [SerializeField]private Transform[] tornadoPoints; 
    public bool EventGenerated = false;

    private void Start()
    {
        tornadoFactory = FindAnyObjectByType<TornadoFactory>();
        blackHoleFactory = FindAnyObjectByType<BlackHoleFactory>(); 
        InvokeRepeating("TornadoGeneration", Random.Range(30, 60), Random.Range(60, 120)); 
        InvokeRepeating("BlackHoleGeneration", Random.Range(120, 150), Random.Range(120, 150)); 
    }
    
    private void TornadoGeneration()
    {
        if (EventGenerated == false)
            try
            {
                tornadoFactory.GetProduct(tornadoPoints[Random.Range(0, 1)].position); 
            }
            catch (Exception e)
            {
                
            }
    }
    private void BlackHoleGeneration()
    {
        if (EventGenerated == false)
            blackHoleFactory.GetProduct(new Vector3(-1.3f, -2.9f, 0f)); 
    }
}
