using System; 
using System.Collections;
using System.Collections.Generic;
using UnityEngine;


public class BlackHoleProduct : MonoBehaviour, IEventProduct
{
    private GameObject go; 
    public GameObject Go { get => go; }
    private GameObject cam;
    [SerializeField] private GameObject particlePrefab; 
    private EventGenerator eventGenerator; 
    
    

    private void Start()
    {
        
        go = gameObject;
        cam = GameObject.Find("Main Camera");
        eventGenerator = GameObject.Find("EventGenerator").GetComponent<EventGenerator>();
        Initialize();
    }

    public void Initialize()
    {
        
        eventGenerator.EventGenerated = true;
        SFXHandler.Instance.BlackHoleSFX();
        StartCoroutine("DestroyCor"); 
        
        
    }
    
    public void Behaviour()
    {
        throw new NotImplementedException();
    }

    IEnumerator DestroyCor()
    {
        yield return new WaitForSeconds(60f);
        GameObject created = Instantiate(particlePrefab, transform.position, Quaternion.identity);
        Destroy(created, 1f); 
        Destroy(go);
        eventGenerator.EventGenerated = false;

    }
}
