using System.Collections;
using UnityEngine;
using System; 

public class BlackHoleFactory : EventFactory
{
    [SerializeField] private BlackHoleProduct prefab;
    [SerializeField] private GameObject canva; 
    public event Action BlackHoleCreated; 
    
    public override IEventProduct GetProduct(Vector2 position)
    {
        
        GameObject go = Instantiate(prefab.gameObject, position, Quaternion.identity);
        BlackHoleProduct product = GetComponent<BlackHoleProduct>(); 
        StartCoroutine("Animation"); 
        BlackHoleCreated?.Invoke();
        return product;
    }

    IEnumerator Animation()
    {
        
        for (int i = 0; i < 10; i++)
        {
            canva.SetActive(true);
            yield return new WaitForSeconds(0.1f); 
            canva.SetActive(false);
            yield return new WaitForSeconds(0.1f); 
        }
        
    }
}
