using System;
using System.Collections;
using UnityEngine;
using TMPro;
public class GrenadeDelayUpdater : MonoBehaviour
{
    [SerializeField] private TMP_Text text;
    [SerializeField] private Animation animT; 
    [SerializeField] private Animation animI;
    [SerializeField] private bool p2 = false; 
    private void Start()
    {
        text.text = "Ready"; 
    }

    public void TimerOn(float seconds)
    {
        StartCoroutine("TimerOnCor", seconds); 
    }

    IEnumerator TimerOnCor(float seconds)
    {
        animI.Play(p2 ? "grenadeP2" : "grenadeP1"); 
        for (int i = (int)seconds; i > 0; i--)
        {
            animT.Stop();
            animT.Play(p2 ? "textP2" : "textP1");
            text.text = i.ToString();
            seconds--; 
            yield return new WaitForSeconds(1f);
        }
        text.text = "Ready";
    }
}
