using System;
using UnityEngine;
using Random = UnityEngine.Random;

public class SFXHandler : MonoBehaviour
{
    private static SFXHandler instance;
    public static SFXHandler Instance
    {
        get
        {
            if (instance == null)
                SetupInstance();
            return instance;
        }
    }

    private void Awake()
    {
        if (instance == null)
        {
            instance = this;
        }
        else
        {
            Destroy(gameObject);
        }
    }

    private static void SetupInstance()
    {
        instance = FindFirstObjectByType<SFXHandler>();
        if (instance == null)
        {
            GameObject obj = new GameObject();
            obj.name = "SFXHandler_Singleton";
            instance = obj.AddComponent<SFXHandler>();
        }
    }

    private void Start()
    {
        audioSrc = GetComponent<AudioSource>();
        InvokeRepeating("BirdSFX", Random.Range(0,30), Random.Range(30,60)); //on vas jouer de mani�re al�atoire le sond d'ambience "birdClip"
    }

    private AudioSource audioSrc;
    [SerializeField] private AudioClip jumpClip;
    [SerializeField] private AudioClip birdClip;
    [SerializeField] private AudioClip shieldClip; 
    [SerializeField] private AudioClip fireShieldClip; 
    [SerializeField] private AudioClip tornadoClip; 
    [SerializeField] private AudioClip swordClip; 
    [SerializeField] private AudioClip damageClip; 
    [SerializeField] private AudioClip blackHoleClip; 
    [SerializeField] private AudioClip rechargeClip; 
    [SerializeField] private AudioClip shotClip; 
    [SerializeField] private AudioClip alienItemSpawnClip; 
    [SerializeField] private AudioClip alienHurtClip; 
    [SerializeField] private AudioClip grenadeClip; 
   


    public void JumpSFX()
    {
        audioSrc.PlayOneShot(jumpClip); 
    }

    public void BirdSFX()
    {
        audioSrc.PlayOneShot(birdClip);
    }
    
    public void ShieldSFX()
    {
        audioSrc.PlayOneShot(shieldClip);
    }

    public void fireShieldSFX()
    {
        audioSrc.PlayOneShot(fireShieldClip); 
    }

    public void TornadoSFX()
    {
        
        audioSrc.PlayOneShot(tornadoClip); 
    }
    public void SwordSFX()
    {
        
        audioSrc.PlayOneShot(swordClip); 
    }
    
    public void DamageSFX()
    {
        
        audioSrc.PlayOneShot(damageClip); 
    }
    public void BlackHoleSFX()
    {
        audioSrc.PlayOneShot(blackHoleClip); 
    }
    public void RechargeSFX()
    {
        audioSrc.PlayOneShot(rechargeClip); 
    }
    public void ShotSFX()
    {
        audioSrc.PlayOneShot(shotClip); 
    }
    public void AlienItemSpawnSFX()
    {
        try
        {
            audioSrc.PlayOneShot(alienItemSpawnClip);
        }
        catch (Exception e)
        {
            
        }
        
    }
    public void AlienHurtSFX()
    {
        audioSrc.PlayOneShot(alienHurtClip); 
    }
    public void GrenadeSFX()
    {
        audioSrc.PlayOneShot(grenadeClip); 
    }
   


}
