using UnityEngine;

public class P2Health : MonoBehaviour
{
    private static P2Health instance; //instance priv�e
    const int HEALTH = 5;
    const int FORTITUDE = 0;
    private int health = HEALTH;
    private int fortitude = FORTITUDE;
    private P2LifeHandler lifeHandler;


    private void Start()
    {
        lifeHandler = FindAnyObjectByType<P2LifeHandler>();
    }
    public static P2Health Instance //instance public 
    {
        get
        {
            if (instance == null)
            {
                SetupInstance();
            }
            return instance;

        }
    }

    public int Health { get => health; set => health = value; }
    public int Fortitude { get => fortitude; set => fortitude = value; }

    private void Awake() //on v�rifie qu'il n'y a qu'une seule et unique instance
    {
        if (instance == null)
        {
            instance = this;
        }
        else
        {
            Destroy(gameObject);
        }
    }

    private static void SetupInstance() //setup de l'instance
    {
        instance = FindFirstObjectByType<P2Health>();
        if (instance == null)
        {
            GameObject obj = new GameObject();
            obj.name = "P1Health_Singleton";
            instance = obj.AddComponent<P2Health>();
        }
    }

    public int UpdateHealth(int op)
    {
        if (op >= 0) //cas ou on donne de la vie 
        {
            health += op;

        }
        else if (op < 0)//cas ou on prend un degat 
        {
            int finalop = op + fortitude;
            if (finalop > 0) //cas ou les degats s'annulent
            {
                finalop = 0;
                return health;
            }
            else //cas ou on prend des degats
            {
                health += (op + fortitude);
                lifeHandler.DamageAnim();
                return health;

            }

        }

        return health;


    }

    public int UpdateFortitude(int op)
    {
        fortitude += op;
        return fortitude;
    }

    public void ResetFortitude()
    {
        fortitude = FORTITUDE;
    }

    public void ResetHealth()
    {
        health = HEALTH;
    }

    private void Update()
    {
        if (health < 0)
            health = 0;
    }






}
