using System.Collections;
using UnityEngine;

public class P2Sword : MonoBehaviour
{
    private Transform player;
    private Transform trans;
    private Player2Input input;
    private int dir = 0;
    public bool soundOK = true;
    [SerializeField] private Collider2D swordCollider;


    private Animation anim;
    [SerializeField] private Transform posL;
    [SerializeField] private Transform posR;
    [SerializeField] private float smooth = 10;
    private bool change = true; 
    



    private void Start()
    {
        player = GameObject.Find("Player2").GetComponent<Transform>();
        input = GameObject.Find("Player2").GetComponent<Player2Input>();
        anim = GetComponent<Animation>();
        trans = GetComponent<Transform>();
       
    }

    private void Update()
    {
        HandleDirection();
        handleAttack();
    }

    private void HandleDirection()
    {

        if (input.Delta2 > 0.001)
        {
            trans.localScale = new Vector3(-0.25f, 0.25f, 0.25f);
            trans.position = posR.position;
        }

        if (input.Delta2 < -0.001)
        {
            trans.localScale = new Vector3(0.25f, 0.25f, 0.25f);
            trans.position = posL.position;
        }
    }

    private void handleAttack()
    {

        if (input.Delta2 > 0.001 || (input.Delta2 == 0 && dir == 0))
        {
            if (Input.GetButton("Fire1"))
            {
                change = false;
                StartCoroutine("Delay"); 
                swordCollider.enabled = true;
                if (soundOK)
                {
                    SFXHandler.Instance.SwordSFX();
                    StartCoroutine("SoundCorrection");
                }
                anim.Play("swordRight");
                StartCoroutine("SwordDeactivate");

            }
            dir = 0;
        }

        if (input.Delta2 < -0.001 || (input.Delta2 == 0 && dir == 1))
        {

            if (Input.GetButton("Fire1"))
            {
                change = false;
                StartCoroutine("Delay"); 
                swordCollider.enabled = true;
                if (soundOK)
                {

                    SFXHandler.Instance.SwordSFX();
                    StartCoroutine("SoundCorrection");
                }

                anim.Play("swordLeft");
                StartCoroutine("SwordDeactivate");
            }
            dir = 1;
        }
    }

    IEnumerator SoundCorrection()
    {
        soundOK = false;
        yield return new WaitForSeconds(.2f);
        soundOK = true;
    }

    IEnumerator SwordDeactivate()
    {
        yield return new WaitForSeconds(.1f);
        swordCollider.enabled = false;
    }
    
    IEnumerator Delay()
    {
        yield return new WaitForSeconds(.5f);
        change = true; 

    }
    
    public bool DeactivatePermission()
    {
        
        if (change)
            return true;
        else
        {
            return false;
        }
    }


}
