using System;
using System.Collections;
using UnityEngine;
using UnityEngine.InputSystem; 

public class RifleP2 : MonoBehaviour
{
    [SerializeField] private GameObject bullet;
    [SerializeField] private GameObject rechargePrefab;
    [SerializeField] private GameObject fireParticle;
    [SerializeField] private Transform gun;
    [SerializeField] private Transform rifle;
    [SerializeField] private Transform bout;
    [SerializeField] private float fireRate;
    [SerializeField] private float forceShoot;
    private bool canShoot = true;
    private bool rechargeState = true;
    private Player2Input input;
    private Transform trans;
    [SerializeField]private Transform posL;
    [SerializeField]private Transform posR;
    public int Chargeur = 30;
    public event Action OnFire; 
    
    

    private void Start()
    {
        input = FindAnyObjectByType<Player2Input>(); 
        trans = GetComponent<Transform>();
    }

    private void Update()
    {
        HandleDirection();
        if (Input.GetButton("Fire1") && canShoot && Chargeur > 0 && rechargeState)
        {
            Shoot();
            StartCoroutine("Delay");
            Chargeur--; 
            SFXHandler.Instance.ShotSFX();
        }
        else if (Chargeur <= 0 && rechargeState || Input.GetButtonDown("RechargeManette") && rechargeState)
        {
            StartCoroutine("Recharge"); 
        }
    }

    private void Shoot()
    {
        //vibrate
        OnFire?.Invoke();
        CameraEffect.Instance.Shake(new Vector3(.025f, .025f, .025f), .1f);
        GameObject created = Instantiate(bullet, gun.position, Quaternion.identity);
        GameObject particle = Instantiate(fireParticle, bout.position, Quaternion.identity);
        created.GetComponent<Rigidbody2D>().AddForce(gun.right * forceShoot, ForceMode2D.Impulse);
        created.GetComponent<Transform>().rotation = gun.rotation;
        particle.GetComponent<Transform>().rotation = gun.rotation;
        Destroy(created, 2f);
        Destroy(particle,.2f);
    }

    IEnumerator Delay()
    {
        canShoot = false; 
        yield return new WaitForSeconds(fireRate);
        canShoot = true; 
    }
    
    IEnumerator Recharge()
    {
        //animation de recharge 
        GameObject created = Instantiate(rechargePrefab, rifle.position, Quaternion.identity);
        created.GetComponent<Rigidbody2D>().angularVelocity = 1000; 
        created.GetComponent<Rigidbody2D>().AddForce(Vector2.up*7, ForceMode2D.Impulse);
        Destroy(created, 2f);
        SFXHandler.Instance.RechargeSFX();
        rechargeState = false; 
        yield return new WaitForSeconds(2f);
        Chargeur = 30; 
        rechargeState = true;
    }
    
    private void HandleDirection()
    {
       
        if (input.Delta2 > 0.001)
        {
            trans.localScale = new Vector3(.5f, 0.5f, .5f); 
            trans.position = posR.position;
            gun.rotation = Quaternion.Euler(0, 0, 0);
        }
        
        if (input.Delta2 < -0.001)
        {
            trans.localScale = new Vector3(-.5f, 0.5f, .5f); 
            trans.position = posL.position;
            gun.rotation = Quaternion.Euler(0, 180, 0);
        }
    }

    public bool DeactivatePermission()
    {
        if (rechargeState && canShoot)
            return true;
        else
        {
            return false;
        }
    }
    
}

