using System;
using System.Collections;
using Unity.VisualScripting;
using UnityEditor;
using UnityEngine;

public class grenadeProduct : MonoBehaviour, IProduct
{
    private string name = "grenade"; 
    public string Name { get => name; set => name = value; }
    private GameObject go;
    private Collider2D col;
    private Transform trans;
    [SerializeField] private float explosionForce = 1000f;
    [SerializeField] private float explosionRadius = 10f;
    [SerializeField] private GameObject particlePrefab; 
    
    private void Start()
    {
        //assign : 
        go = gameObject;
        col = go.GetComponent<Collider2D>();
        trans = GetComponent<Transform>();
        //function : 
        Initialize();
    }

    public void Initialize()
    {
        StartCoroutine("ColLateActivation");
        StartCoroutine("ExplodeCor");
    }

    public void Behavior()
    {
        throw new System.NotImplementedException();
    }

    public GameObject Go { get => go; }
    

    IEnumerator ColLateActivation()
    {
        yield return new WaitForSeconds(0.5f);
        col.enabled = true; 
    }

    IEnumerator ExplodeCor()
    {
        Vector2 dir = Vector2.zero;  
        yield return new WaitForSeconds(2f);
        //FX : 
        //particle : 
        GameObject particle = Instantiate(particlePrefab, trans.position, Quaternion.identity);
        Destroy(particle, 1f);
        //sound : 
        SFXHandler.Instance.GrenadeSFX();
        //shake : 
        CameraEffect.Instance.Shake(new Vector3(0.5f, 0.5f, 0.5f), 1f);
        //Explosion : 
        Collider2D[] colliders = Physics2D.OverlapCircleAll(transform.position, explosionRadius);
        foreach (Collider2D col in colliders) 
        {
            if (col.gameObject.CompareTag("Player") || col.gameObject.CompareTag("Player2"))
            {
                //force : 
                dir = col.gameObject.transform.position - transform.position; 
                dir.Normalize();
                col.gameObject.GetComponent<Rigidbody2D>().AddForce(dir * explosionForce);
                //damage : 
                if (col.gameObject.CompareTag("Player"))
                {
                    P1Health.Instance.UpdateHealth(-3);
                    col.GetComponent<P1LifeHandler>().DamageAnim(); 
                    col.GetComponent<P1LifeHandler>().ImmunityTimeStart();
                    SFXHandler.Instance.DamageSFX();
                }
                else if (col.gameObject.CompareTag("Player2"))
                {
                    P2Health.Instance.UpdateHealth(-3); 
                    col.GetComponent<P2LifeHandler>().DamageAnim(); 
                    col.GetComponent<P2LifeHandler>().ImmunityTimeStart();
                    SFXHandler.Instance.DamageSFX();
                }
            }

            if (col.gameObject.CompareTag("damageStay"))
            {
                try
                {
                    col.gameObject.GetComponent<AlienProduct>().Damage(-3);
                }
                catch (Exception e )
                {
                    
                }
            }
        }
        Destroy(gameObject);
    }

    private void OnDrawGizmos()
    {
        Gizmos.color = Color.red;
        Gizmos.DrawWireSphere(transform.position, explosionRadius);
    }
}
