using System;
using UnityEngine;

public class WeaponSelectionP1 : MonoBehaviour
{
    [SerializeField] private GameObject rifle; 
    [SerializeField] private GameObject sword;
    private string activeWeapon; 
    
    public string ActiveWeapon 
    {
        get =>activeWeapon;
        set => activeWeapon = value; 
    }
    private void Update()
    {
        HandleChoose(); 
    }

    private void HandleChoose()
    {
        if (Input.GetKeyDown(KeyCode.E))
        {
            if (rifle.activeSelf && rifle.GetComponent<RifleP1>().DeactivatePermission())
            {
                rifle.SetActive(false);
                sword.SetActive(true);
                activeWeapon = "sword"; 
            }
            else if (sword.activeSelf && sword.GetComponent<P1Sword>().DeactivatePermission())
            {
                sword.SetActive(false);
                rifle.SetActive(true);
                activeWeapon = "rifle";
                sword.GetComponent<P1Sword>().soundOK = true; 
            }
        }
    }
}
