using System.Collections;
using UnityEngine;

public class PlayerPower : MonoBehaviour
{
    private Transform trans;
    private RotatoryFactory rotatory;
    private ShieldPowerFatory shield;
    private AlienFactory alien;
    [SerializeField] private GameObject grenadePrefab;
    
    
    private bool powerOn = false;
    private PowerTimeHandler timeHandler;
    [SerializeField] private PowerIcoHandler rotatoryP1Ico;
    [SerializeField] private PowerIcoHandler shieldP1Ico;
    private P1Health health;
    private PlayerInput input;
    [SerializeField] private float throwForce = 10f;
    [SerializeField] private float offset = .5f;  
    
    


    public bool PowerOn { get => powerOn; set => powerOn = value; }

    private void Start()
    {
        trans = GetComponent<Transform>();
        rotatory = FindAnyObjectByType<RotatoryFactory>();
        timeHandler = GetComponent<PowerTimeHandler>(); 
        shield = FindAnyObjectByType<ShieldPowerFatory>();
        health = FindAnyObjectByType<P1Health>(); 
        alien = FindAnyObjectByType<AlienFactory>();
        input = GetComponent<PlayerInput>();
    }

    private void OnCollisionEnter2D(Collision2D collision)
    {
        HandlepowerCollision(collision);
    }
    private void HandlepowerCollision(Collision2D col)
    {     

        if (powerOn == false)
        {
            switch (col.gameObject.tag)
            {
                case "RotatoryShield":
                    
                    StartCoroutine("rotatoryGeneration");
                    PowerAccesHandler();
                    rotatoryP1Ico.Activate();
                    SFXHandler.Instance.fireShieldSFX();

                    break;
                case "Shield":
                    shield.GetProduct(trans.position);
                    PowerAccesHandler();
                    shieldP1Ico.Activate();
                    StartCoroutine("ShieldPowerHandler");
                    SFXHandler.Instance.ShieldSFX();
                    break;  
                case "AlienItem":
                    alien.GetProduct(trans.position);
                    SFXHandler.Instance.AlienItemSpawnSFX();
                    break; 
                case "Grenade": 
                    Destroy(col.gameObject);
                    print("Grenade");
                    break; 
                    
                default:
                    break;
            }
            
        }
        
    }

    IEnumerator rotatoryGeneration()
    {
        rotatory.GetProduct(gameObject.transform.position);
        yield return new WaitForSeconds(.2f);
        rotatory.GetProduct(gameObject.transform.position);
        yield return new WaitForSeconds(.2f);
        rotatory.GetProduct(gameObject.transform.position);
        yield return new WaitForSeconds(.2f);
        rotatory.GetProduct(gameObject.transform.position);
    }

    public void PowerAccesHandler()
    {
        powerOn = true;
        timeHandler.TimeHandler(15); //UI
        StartCoroutine("PowerAccesCor"); 
    }

    IEnumerator PowerAccesCor()
    {
        yield return new WaitForSeconds(15f); 
        powerOn = false;
    }

    IEnumerator ShieldPowerHandler()
    {
        health.UpdateFortitude(3);
        yield return new WaitForSeconds(15f);
        health.UpdateFortitude(-3); 
    }

    public void ThrowGrenade()
    {
        GameObject created = Instantiate(grenadePrefab, trans.position + new Vector3(0, offset, 0), Quaternion.identity);
        created.GetComponent<Rigidbody2D>().AddForce(input.ToCursor * throwForce);
    }
}
