using UnityEngine;

public class PlayerMove : MonoBehaviour
{
    private Rigidbody2D rig;
    private CapsuleCollider2D col;
    private Transform trans;
    private PlayerInput input;
    private Vector2 playerMoveVector;
    private Transform target;
    [SerializeField] private GameObject right; 
    [SerializeField] private GameObject left;
    
    
    
    
    

    private void Start()
    {
        rig = GetComponent<Rigidbody2D>();  
        col = GetComponent<CapsuleCollider2D>();
        trans = GetComponent<Transform>();  
        input = FindAnyObjectByType<PlayerInput>();
        
         
}
    private void Update()
    {
        HandleMove();
        
    }

    private void HandleMove()
    {
        if (input.jumpCount < 2)
        {
            playerMoveVector = new Vector2(input.Delta, 0);
            //rig.AddForce(playerMoveVector);

            trans.Translate(playerMoveVector);
        }
        else //reduction de la vitesse de d�placement apr�s le deuxi�me saut pour plus de r�alisme
        {
            playerMoveVector = new Vector2(input.Delta, 0);
            //rig.AddForce(playerMoveVector);

            trans.Translate(playerMoveVector/2);
        }


    }

    public void Jump(float jumpForce) //instancier dans le input
    {
        Vector2 jumpVector = new Vector2(0, jumpForce);
        SFXHandler.Instance.JumpSFX();
        rig.AddForce(jumpVector);
    }


 
}
