using System.Collections;
using UnityEngine;
using System;
using Unity.VisualScripting;

public class PlayerInput : MonoBehaviour
{
    public float Delta;
    [SerializeField] private float speed;
    [SerializeField] private float jumpForce;
    private PlayerMove move;
    public float jumpCount = 0;
    [SerializeField] private float resetJumpTime;
    public Vector3 ToCursor = Vector2.zero;
    private Vector3 MousePos;
    private PlayerPower power;
    private bool canThrowGrenade = true;
    [SerializeField] private float grenadeThrowDelay = 25f; 
    private Camera cam; 
    [SerializeField] private GrenadeDelayUpdater delayUI; 
    

    private void Start()
    {
        move = GetComponent<PlayerMove>();
        power = GetComponent<PlayerPower>();
        cam = GameObject.Find("Main Camera").GetComponent<Camera>();
    }

    private void Update()
    {
        GetAxis();
        Jumping();
        ToCursorHandler();
        ThrowGrenadeHandler(); 
    }

    private void GetAxis()
    {
        Delta = Input.GetAxis("Horizontal") * Time.deltaTime * speed;
    }

    private void Jumping()
    {
        if (Input.GetKeyDown(KeyCode.Space) && jumpCount < 2)
        {

            jumpCount++;
            move.Jump(jumpForce);
            
        }
    }
    private void OnCollisionEnter2D(Collision2D collision)
    {
        if (collision.gameObject.CompareTag("ground"))
            jumpCount = 0;
    }

    private void ToCursorHandler()
    {
        MousePos = cam.ScreenToWorldPoint(Input.mousePosition).normalized;
        ToCursor = new Vector2(MousePos.x - transform.position.x, MousePos.y - transform.position.y);
    }

    private void ThrowGrenadeHandler()
    {
        if (Input.GetKeyDown(KeyCode.LeftShift) && canThrowGrenade)
        {
            delayUI.TimerOn(grenadeThrowDelay);
            power.ThrowGrenade();
            StartCoroutine("GrenadePermission"); 

        }
    }

    IEnumerator GrenadePermission()
    {
        canThrowGrenade = false;
        yield return new WaitForSeconds(grenadeThrowDelay);
        canThrowGrenade = true;
    }

    private void OnDrawGizmos()
    {
        Gizmos.DrawLine(transform.position, MousePos);
    }
}
