using System.Collections;
using UnityEngine;

public class Player2Power : MonoBehaviour
{
    private Transform trans;

    
    private RotatoryFactory rotatory;
    private ShieldPowerFatory shield;
    private string powerName;
    private AlienFactory alien; 
    [SerializeField] private GameObject grenadePrefab;

    private bool powerOn = false;
    private PowerTimeHandler timeHandler;
    [SerializeField] private PowerIcoHandler rotatoryP1Ico;
    [SerializeField] private PowerIcoHandler shieldP1Ico;
    private P2Health health;
    private Player2Input input;
    [SerializeField] private float throwForce = 10f;
    [SerializeField] private float offset = .5f;
    private Vector2 baseDir;
    private GameObject Player1; 


    public bool PowerOn { get => powerOn; set => powerOn = value; }

    private void Start()
    {
        trans = GetComponent<Transform>();
        rotatory = FindAnyObjectByType<RotatoryFactory>();
        timeHandler = GetComponent<PowerTimeHandler>();
        shield = FindAnyObjectByType<ShieldPowerFatory>();
        health = FindAnyObjectByType<P2Health>();
        alien = FindAnyObjectByType<AlienFactory>();
        input = GetComponent<Player2Input>();
        Player1 = GameObject.Find("Player"); 
    }

    private void OnCollisionEnter2D(Collision2D collision)
    {
        HandlepowerCollision(collision);
    }
    private void HandlepowerCollision(Collision2D col)
    {

        if (powerOn == false)
        {
            switch (col.gameObject.tag)
            {
                case "RotatoryShield":

                    StartCoroutine("rotatoryGeneration");
                    PowerAccesHandler();
                    rotatoryP1Ico.Activate();
                    SFXHandler.Instance.fireShieldSFX(); 
                    break;
                case "Shield":
                    shield.GetProduct(trans.position);
                    PowerAccesHandler();
                    shieldP1Ico.Activate();
                    StartCoroutine("ShieldPowerHandler");
                    SFXHandler.Instance.ShieldSFX(); 
                    break;
                case "AlienItem":
                    alien.GetProduct(trans.position);
                    SFXHandler.Instance.AlienItemSpawnSFX();
                    break; 
                case "Grenade": 
                    Destroy(col.gameObject);
                    print("Grenade");
                    break; 
                default:
                    break;
            }
        }

    }

    IEnumerator rotatoryGeneration()
    {
        rotatory.GetProduct(gameObject.transform.position);
        yield return new WaitForSeconds(.2f);
        rotatory.GetProduct(gameObject.transform.position);
        yield return new WaitForSeconds(.2f);
        rotatory.GetProduct(gameObject.transform.position);
        yield return new WaitForSeconds(.2f);
        rotatory.GetProduct(gameObject.transform.position);
    }

    public void PowerAccesHandler()
    {
        powerOn = true;
        timeHandler.TimeHandler(15); //UI
        StartCoroutine("PowerAccesCor");
    }

    IEnumerator PowerAccesCor()
    {
        yield return new WaitForSeconds(15f);
        powerOn = false;
    }

    IEnumerator ShieldPowerHandler()
    {
        health.UpdateFortitude(3);
        yield return new WaitForSeconds(15f);
        health.UpdateFortitude(-3);
    }
    
    public void ThrowGrenade()
    {
        GameObject created = Instantiate(grenadePrefab, trans.position + new Vector3(0, offset, 0), Quaternion.identity);
        if (input.dir.x <= .1f && input.dir.y <= .1f)
        {
            baseDir = Player1.transform.position - trans.position;
            created.GetComponent<Rigidbody2D>().AddForce(baseDir.normalized * throwForce);
        }
        else
        {
            created.GetComponent<Rigidbody2D>().AddForce(input.dir * throwForce);
        }
        
    }
}
