using System.Collections;
using UnityEngine;
using System; 

public class Player2Input : MonoBehaviour
{
    public float Delta2;
    [SerializeField] private float speed2;
    [SerializeField] private float jumpForce2;
    private Player2Move move;
    [SerializeField]public float jumpCount2 = 0;
    [SerializeField] private float resetJumpTime;
    public Vector3 ToCursor = Vector2.zero;
    private Vector3 MousePos;
    private Player2Power power;
    private bool canThrowGrenade = true;
    [SerializeField] private float grenadeThrowDelay = 25f; 
    private Camera cam; 
    public Vector2 dir = Vector2.zero;
    [SerializeField] private GrenadeDelayUpdater delayUI;


    private void Start()
    {
        move = GetComponent<Player2Move>();
        power = GetComponent<Player2Power>();
        cam = GameObject.Find("Main Camera").GetComponent<Camera>();
    }

    private void Update()
    {
        GetAxis();
        Jumping();
        ToCursorHandler();
        ThrowGrenadeHandler(); 
        DirCalculator();
    }

    private void GetAxis()
    {
        Delta2 = Input.GetAxis("Horizontal2") * Time.deltaTime * speed2;
    }

    private void Jumping()
    {
        if (Input.GetButtonDown("Jump") && jumpCount2 < 2)
        {

            jumpCount2++;
            move.Jump(jumpForce2);


        }
    }
    private void OnCollisionEnter2D(Collision2D collision)
    {
        if (collision.gameObject.CompareTag("ground"))
            jumpCount2 = 0;
    }
    
    private void ToCursorHandler()
    {
        //MousePos = cam.ScreenToWorldPoint(Input.mousePosition);
        //ToCursor = new Vector2(MousePos.x - transform.position.x, MousePos.y - transform.position.y);
    }

    private void ThrowGrenadeHandler()
    {
        if ( Input.GetButtonDown("Fire3") && canThrowGrenade)
        {
            delayUI.TimerOn(grenadeThrowDelay);
            power.ThrowGrenade();
            StartCoroutine("GrenadePermission"); 

        }
    }

    IEnumerator GrenadePermission()
    {
        canThrowGrenade = false;
        yield return new WaitForSeconds(grenadeThrowDelay);
        canThrowGrenade = true;
    }

    private void OnDrawGizmos()
    {
        Gizmos.DrawLine(transform.position, MousePos);
    }
    
    private void DirCalculator()
    {
        dir = new Vector2(Input.GetAxis("Horizontal2"), Input.GetAxis("Vertical"));
    }
    



}