using System.Collections;
using UnityEngine;
using System; 

public class P2LifeHandler : MonoBehaviour
{
    private P2Health health;
    private int damage;
    private DamageSet damcol;
    private bool isDamaged = false;
    [SerializeField] private Material baseMat;
    [SerializeField] private Material damagedMat;
    private Renderer rend;
    public event Action Damage2; 
    

    private void Start()
    {
        health = FindAnyObjectByType<P2Health>();
        rend = GetComponent<Renderer>();
        
    }

    private void OnTriggerEnter2D(Collider2D collision)
    {
        if ((collision.gameObject.CompareTag("damage") || collision.gameObject.CompareTag("damageStay")) && !isDamaged)
        {
            Damage2?.Invoke();
            SFXHandler.Instance.DamageSFX(); 
            damcol = collision.GetComponent<DamageSet>();
            damage = damcol.Damage;

            health.UpdateHealth(damage);
            if (collision.gameObject.CompareTag("damage"))
                Destroy(collision.gameObject);
            StartCoroutine("ImmunityTime");




        }
    }
    public void ImmunityTimeStart()
    {
        
        StartCoroutine("ImmunityTime");
    }
    IEnumerator ImmunityTime()
    {
        isDamaged = true;
        yield return new WaitForSeconds(3f);
        isDamaged = false;
    }

    public void DamageAnim()
    {
        StartCoroutine("DamageAnimCor");
    }
    IEnumerator DamageAnimCor()
    {
        rend.material = damagedMat;
        yield return new WaitForSeconds(.5f);
        rend.material = baseMat;
        yield return new WaitForSeconds(.5f);
        rend.material = damagedMat;
        yield return new WaitForSeconds(.5f);
        rend.material = baseMat;
        yield return new WaitForSeconds(.5f);
        rend.material = damagedMat;
        yield return new WaitForSeconds(.5f);
        rend.material = baseMat;
        yield return new WaitForSeconds(.5f);
    }
    
    
}
