using System;
using System.Collections;
using UnityEngine;

public class P1LifeHandler : MonoBehaviour
{
    private P1Health health;
    private int damage;
    private DamageSet damcol;
    private bool isDamaged = false;
    [SerializeField] private Material baseMat;
    [SerializeField] private Material damagedMat;
    private Renderer rend;
    private Animator anim;
    public event Action Damage; 


    private void Update()
    {
        anim.SetInteger("life", P1Health.Instance.Health); 
    }

    private void Start()
    {
        anim = GetComponent<Animator>();
        health = FindAnyObjectByType<P1Health>();
        rend = GetComponent<Renderer>();
          
    }

    private void OnTriggerEnter2D(Collider2D collision)
    {
        if ((collision.gameObject.CompareTag("damage") || collision.gameObject.CompareTag("damageStay")) && !isDamaged)
        {
            Damage?.Invoke();
            SFXHandler.Instance.DamageSFX();    
            damcol = collision.GetComponent<DamageSet>();
            damage = damcol.Damage; 
   
            health.UpdateHealth(damage);
            if (collision.gameObject.CompareTag("damage"))
                Destroy(collision.gameObject);
            StartCoroutine("ImmunityTime");
            



        }
    }
    

    IEnumerator ImmunityTime()
    {
        isDamaged = true;
        yield return new WaitForSeconds(3f);
        isDamaged = false; 
    }

    public void DamageAnim()
    {
        StartCoroutine("DamageAnimCor");
    }
    IEnumerator DamageAnimCor()
    {
        rend.material = damagedMat;
        yield return new WaitForSeconds(.5f);
        rend.material = baseMat;
        yield return new WaitForSeconds(.5f);
        rend.material = damagedMat;
        yield return new WaitForSeconds(.5f);
        rend.material = baseMat;
        yield return new WaitForSeconds(.5f);
        rend.material = damagedMat;
        yield return new WaitForSeconds(.5f);
        rend.material = baseMat;
        yield return new WaitForSeconds(.5f);        
    }

    public void ImmunityTimeStart()
    {
        StartCoroutine("ImmunityTime");
    }

 

    
}
