using System;
using System.Collections;
using UnityEngine;

public class MainCameraObserver : MonoBehaviour
{
    private BlackHoleFactory blackHoleFactory;
    [SerializeField]private Animation anim; 

    private void Start()
    {
        blackHoleFactory ??= FindAnyObjectByType<BlackHoleFactory>(); 
        blackHoleFactory.BlackHoleCreated += OnBlackHoleCreated; 
    }

    private void OnDestroy()
    {
        blackHoleFactory.BlackHoleCreated -= OnBlackHoleCreated; 
    }

    private void OnBlackHoleCreated()
    {
        anim.Stop();
        anim.Play("camRotate"); 
    }
    
    

    
    
   
}
