using UnityEngine;

public class HealthTextRObserver : MonoBehaviour
{
    private P1LifeHandler healthSubject; 
    private Animation anim; 

    private void Start()
    {
        healthSubject ??= FindAnyObjectByType<P1LifeHandler>();
        healthSubject.Damage += OnDamage; 
        anim = GetComponent<Animation>();
    }

    private void OnDestroy()
    {
        healthSubject.Damage -= OnDamage; 
    }

    private void OnDamage()
    {
        anim.Play("P1HealthDamage"); 
    }  
}
