using UnityEngine;
using System.Collections;
using System.Collections.Generic;
using System; 
using TMPro;
public class EndGameObserver : MonoBehaviour
{
    private DeathSubject deathSubject;
    
    [SerializeField] private TMP_Text deathText;
    [SerializeField] private GameObject deathCanva; 
    
   

    private void Start() 
    {
        deathSubject ??= FindAnyObjectByType<DeathSubject>();
        deathSubject.p1Death += OnP1Death;
        deathSubject.p2Death += OnP2Death; 
    }

    private void OnDestroy()
    {
        deathSubject.p1Death -= OnP1Death;
        deathSubject.p2Death -= OnP2Death;
    }

    private void OnP1Death()
    {
        
        deathText.text = "Le joueur 2 a gagner !! ";
        GeneralDeathBehaviour();        
    }

    private void OnP2Death()
    {
        deathText.text = "Le joueur 1 a gagner !! ";
        GeneralDeathBehaviour(); 
    }

    private void GeneralDeathBehaviour()
    {
        Time.timeScale = 0;
        deathCanva.SetActive(true);
        
    }
}
