using UnityEngine;
using System; 

public class DeathSubject : MonoBehaviour
{
    private P1Health p1Health;
    private P2Health p2Health; 

    public event Action p1Death; 
    public event Action p2Death; 

    private void Start()
    {
        p1Health = FindAnyObjectByType<P1Health>(); 
        p2Health = FindAnyObjectByType<P2Health>(); 
    }

    private void Update()
    {
        if (p1Health.Health == 0)
        { 
            p1Death?.Invoke(); 
        }

        if (p2Health.Health == 0)
        {
            p2Death?.Invoke(); 
        }
    }

}

