using System;
using UnityEngine;

public class BulletRObserver : MonoBehaviour
{
    private RifleP1 rifleSubject;
    private Animation anim; 

    private void Start()
    {
        rifleSubject ??= FindAnyObjectByType<RifleP1>();
        rifleSubject.OnFire += OnFired; 
        anim = GetComponent<Animation>();
    }

    private void OnDestroy()
    {
        rifleSubject.OnFire -= OnFired; 
    }

    private void OnFired()
    {
        anim.Play("amoRFire"); 
    }
}
