﻿using UnityEngine;

public class BulletLObserver : MonoBehaviour
{
    private RifleP2 rifleSubject;
    private Animation anim; 

    private void Start()
    {
        rifleSubject ??= FindAnyObjectByType<RifleP2>();
        rifleSubject.OnFire += OnFired; 
        anim = GetComponent<Animation>();
    }

    private void OnDestroy()
    {
        rifleSubject.OnFire -= OnFired; 
    }

    private void OnFired()
    {
        anim.Play("amoLFire"); 
    }  
}