using UnityEngine;
using UnityEngine.Rendering;
using System.Collections;

public class FollowBoat : MonoBehaviour
{
	[SerializeField]
	private Transform positionToFollow;
	[SerializeField]
	private float followSpeed;
	[SerializeField]
	private GameObject bullet;
	private int fireRate = 3; 
	private bool startFollow = true;
	private float shotPower = 4000f;
	[SerializeField]
	private GameObject shootVFX;
	[SerializeField]
	private Transform gunPosition; 

	
	void ShootPlayer()
	{
		if (Vector3.Distance(positionToFollow.position, transform.position) < 60)
		{
			GameObject createdVFX = Instantiate(shootVFX, gunPosition.position, Quaternion.identity);
			Destroy(createdVFX, 3f);
			GameObject go = Instantiate(bullet, gunPosition.position, Quaternion.identity);
			go.GetComponent<Rigidbody>().AddForce(gunPosition.forward * shotPower);
			Destroy(go, 10f);
		}
		
	}
	void Start()
	{
		
		InvokeRepeating("ShootPlayer", fireRate, fireRate);
		
	}
	private void goFast()
	{
		followSpeed *= 10; 
	}
    
    void LateUpdate()
    {
		if (startFollow)
		{
			transform.position = Vector3.Lerp(transform.position, positionToFollow.position, followSpeed * Time.deltaTime);
			transform.rotation = Quaternion.Lerp(transform.rotation, positionToFollow.rotation, followSpeed * Time.deltaTime);
		}
		
    }
	
}
