using System.Reflection.Emit;
using UnityEngine;
using TMPro; 

public class BoatHealth : MonoBehaviour
{
	[SerializeField]private int vie = 5;
	[SerializeField] private bool isPlayer = false;
	[SerializeField] private TMP_Text healthText; 

	
	public void takeDamage()
	{
		vie--;
		if (isPlayer)
			SetHealthUI();
		if (vie == 0)
		{
			Flow(); //fonction couler le bateau
		}
	}

	private void Flow()
	{
		print("Bloup !");
		if (!isPlayer)
		{
			gameObject.GetComponent<FollowBoat>().enabled = false;
			transform.Find("EnnemyPosition").parent = null; 
		}
			
		Rigidbody rig = gameObject.GetComponent<Rigidbody>();
		rig.mass = 4; 
		rig.isKinematic = false;
		rig.useGravity = true;
		rig.constraints  = RigidbodyConstraints.None;
		
	}

	private void SetHealthUI()
	{
		healthText.text = vie + "/5"; 
	}
}
