using UnityEngine;
using UnityEngine.UI;//UI
using UnityEngine.SceneManagement; //gestion des scenes 

public class BoatControl : MonoBehaviour
{
	// Start is called once before the first execution of Update after the MonoBehaviour is created
	[SerializeField]
	private GameObject[] sails; //tableau des voiles
	[SerializeField]
	private ConstantForce cf; // Component 
	[SerializeField]
	private Rigidbody rig;//Component
	[SerializeField]
	private Transform[] leftGuns; //tableau de component des canons de gauche
	[SerializeField]
	private Transform[] rightGuns; //tableau de component des canons de droits
	[SerializeField]
	private float speed = 0.3f; //variable de vitesse de lacet du bateau
	[SerializeField]
	private GameObject bullet; //prefab boulet de canon
	[SerializeField]
	private Transform frontGun; //component du canon de face
	[SerializeField]
	private GameObject shootVFX; //VFX d'explosion 
	[SerializeField]
	private AudioClip shotSfx; //SFX d'explosion 
	private AudioSource audioSrc; //component audio 
	private float shotPower = 3000f; //puissance de feu
	private float dir; //direction
	private bool canShoot = true; //tat de la capacit  tirer
	private float reloadTime = 2f; //temps de rechargement des canons
	[SerializeField]
	private Button canShootIndicator; //component de l'indicateur de la variable d'tat "peut tirer" 
    void Start()
    {
		audioSrc = GetComponent<AudioSource>();
		Cursor.lockState = CursorLockMode.Locked;	//verouillage de la souris 
    }
	private void Update()
	{
		handleSails();//Gestion des voiles
		handleSteering(); //Gestion du gouvrnail
		handleShoot(); //tir du canon
		
	}
	void handleSails()
	{
		if (Input.GetKeyDown(KeyCode.Space))
		{
			
			cf.enabled = !cf.enabled;
			Vector3 v = cf.enabled ? Vector3.one : new Vector3(1, 0.2f, 0.2f); 
			foreach (GameObject go in sails)
			{
				iTween.ScaleTo(go, v, 2f );

			}
		}
	}
	private void handleSteering()
	{
		if (cf.enabled)
		{
			dir = Mathf.SmoothStep(dir, Input.GetAxis("Horizontal"), Time.deltaTime* 10);
			Vector3 angularSpeed = new Vector3(0, dir * speed, 0);
			rig.angularVelocity = angularSpeed;

		}
	}
	private void handleShoot()
	{
		if (Input.GetMouseButtonDown(0))//gauche/left gun
		{
			foreach(Transform t in leftGuns)
			{
				ShotBullet(t);
			}
			Rechargement();
		}

		if (Input.GetMouseButtonDown(1))//droite/right gun
		{
			foreach (Transform t in rightGuns)
			{
				ShotBullet(t); 
			}
			Rechargement(); 
		}

		if (Input.GetMouseButtonDown(2)) //droite/right gun
		{
			ShotBullet(frontGun);
			Rechargement();
		}

	}
	private void ShotBullet(Transform t)
	{
		if (!canShoot)
			return;

		audioSrc.PlayOneShot(shotSfx);
		GameObject createdVFX = Instantiate(shootVFX, t.position, Quaternion.identity);
		Destroy(createdVFX, 3f);
		GameObject go = Instantiate(bullet, t.position, Quaternion.identity);
		go.GetComponent<Rigidbody>().AddForce(t.forward * shotPower);
		Destroy(go, 10f);
		
	}

	private void Reload()
	{
		canShoot=true;
		canShootIndicator.interactable = true; 
	}

	private void Rechargement()
	{
		canShootIndicator.interactable = false;
		canShoot = false;
		Invoke("Reload", reloadTime);
	}

	private void OnTriggerEnter(Collider col)
	{
		if (col.gameObject.CompareTag("island"))
		{
			SceneManager.LoadScene("island1");  //celle ci doit tre renseigner dans les builds
		}
	}
	
}
